# Product Recall Scanner - Test Files

This directory contains sample product files for testing the Product Recall Scanner agent.

## Files Included

### 1. sample_products.csv
- Standard CSV format
- 10 diverse products across multiple categories
- Mix of potentially recalled and safe products

### 2. sample_products.xlsx
- Excel format with two sheets
- Products sheet: Same 10 products as CSV
- Metadata sheet: File information

### 3. sample_products.json
- JSON format with nested structure
- Includes metadata and products array
- Same 10 products as other files

### 4. sample_products_small.csv
- Smaller CSV with only 5 products
- Useful for quick testing

### 5. known_recalled_products.csv
- Contains products with known recalls
- Useful for validating detection accuracy
- Includes notes about recall reasons

### 6. safe_products.csv
- Contains products unlikely to be recalled
- Generic office and consumer items
- Useful for testing false positive rates

## Product Categories Included

- Baby Products
- Toys
- Vehicles
- Food Products
- Medical Devices
- Electronics
- Auto Parts
- Furniture
- Apparel

## Known Recalls in Test Data

Several products in the sample files have had real recalls:
- Philips DreamStation CPAP (2021 recall)
- Takata Airbags (ongoing recalls since 2013)
- Fisher-Price Rock 'n Play (2019 recall)
- Samsung Galaxy Note 7 (2016 recall)
- Jif Peanut Butter (2022 recall)

## Usage

Upload any of these files to the Product Recall Scanner agent to test:
1. File parsing functionality
2. Recall detection accuracy
3. Result formatting and display
4. Export functionality

## Testing Scenarios

1. **Basic Functionality**: Use sample_products_small.csv
2. **Recall Detection**: Use known_recalled_products.csv
3. **False Positive Check**: Use safe_products.csv
4. **Format Support**: Test CSV, Excel, and JSON versions
5. **Full Dataset**: Use sample_products.csv or .xlsx

Generated: 2025-12-04 12:11:54
