# Job Requirements - Senior Mainframe Developer

## Position Overview
Seeking an experienced Senior Mainframe Developer to design, develop, and maintain enterprise-level mainframe applications supporting critical business operations.

## Required Qualifications

### Experience
- 8+ years of mainframe application development experience
- Proven track record in enterprise-level mainframe environments processing millions of daily transactions
- Experience leading technical teams and mentoring junior developers
- Strong background in banking, finance, healthcare, or insurance domains

### Technical Skills

#### Core Mainframe Technologies (Required)
- COBOL (COBOL II, COBOL/370, Enterprise COBOL)
- JCL (Job Control Language)
- CICS (Customer Information Control System)
- DB2 database management
- VSAM (Virtual Storage Access Method)
- TSO/ISPF
- z/OS operating system

#### Database & Data Management
- DB2 - expert level
- SQL query optimization and tuning
- IMS DB/DC
- DL/I
- Database performance optimization

#### Development Tools
- Endeavor/Endevor version control
- Changeman
- File-AID
- Xpediter debugger
- Abend-AID
- SPUFI
- QMF

#### Performance & Monitoring Tools
- IBM Strobe
- Omegamon
- BMC MainView or Compuware tools
- Experience with MIPS optimization

#### Additional Programming Languages (Preferred)
- Assembler
- PL/I

### Core Competencies

#### Performance Optimization
- Proven ability to optimize batch and online systems
- Experience reducing processing time by 30%+ through code optimization
- MIPS reduction experience (20%+ reduction preferred)
- Batch window optimization and reduction
- CPU utilization optimization

#### System Reliability & Availability
- Disaster recovery planning and implementation
- Achieving 99.9%+ system availability
- RTO (Recovery Time Objective) implementation under 4 hours
- Production support and incident resolution
- 95%+ first-time resolution rate

#### Development Practices
- Agile and Waterfall methodologies
- DevOps for Mainframe
- Automated testing framework implementation
- Code review processes
- Root cause analysis
- Technical documentation

### Project Experience Required
- Managing 15+ concurrent projects
- Legacy system modernization
- Migration from legacy COBOL to Enterprise COBOL
- Performance tuning initiatives resulting in 40%+ efficiency improvements
- Cross-functional team collaboration (QA, infrastructure, business stakeholders)

### Leadership & Collaboration
- Experience mentoring junior developers
- Code review leadership
- Cross-functional team coordination
- Business analyst and project manager collaboration
- Requirements gathering and translation to technical specifications

## Preferred Qualifications

### Certifications
- IBM Certified Application Developer - COBOL
- IBM Certified Database Administrator - DB2
- IBM z/OS Systems Programming Certification
- ITIL Foundation Certificate in IT Service Management

### Additional Skills
- Git integration for mainframe
- SCLM (Software Configuration and Library Manager)
- IMS DB/DC

### Professional Memberships
- COMMON
- SHARE
- International DB2 Users Group (IDUG)

## Key Performance Indicators

### Quality Metrics
- Zero critical production defects on major releases
- 28%+ reduction in defect rates
- Comprehensive unit and integration testing

### Performance Metrics
- 35%+ reduction in processing time
- 40%+ improvement in system efficiency
- 22%+ MIPS reduction
- 50%+ improvement in database query performance
- 45%+ reduction in application response time

### Business Impact
- Support processing of 2M-5M+ daily transactions
- Monthly cost reductions through optimization ($150K+ preferred)
- 60%+ reduction in maintenance time through modernization
- Regulatory audit compliance with zero findings

## Education
- Bachelor's degree in Computer Science or related field required
- Coursework in Data Structures, Database Systems, Software Engineering, Operating Systems preferred

## Work Environment
- Enterprise mainframe environment (MVS, z/OS, OS/390)
- Banking, financial services, healthcare, or insurance industry
- High-volume transaction processing systems
- Critical production support requirements
- On-call rotation for production support

## Additional Requirements
- Strong analytical and problem-solving skills
- Excellent written and verbal communication
- Ability to work independently and in team settings
- Willingness to support 24/7 production systems
- Open to relocation (if applicable)
- Immediate availability preferred

---

## Nice-to-Have Qualifications
- Spanish language skills (conversational level)
- Experience with healthcare claims processing systems
- Policy administration system experience
- Year-end processing experience with zero incidents
- Experience in regulated industries (banking, healthcare, insurance)
