Mainframe Developers are responsible for the design, creation, and maintenance of mainframe computer systems and software applications.
Their primary duties and responsibilities include:
Designing, coding, testing, and debugging mainframe software applications
Collaborating with project managers and business analysts to understand and analyze project requirements
Creating and modifying mainframe applications using programming languages like COBOL, JCL, DB2, and CICS
Performing performance tuning of mainframe systems and applications
Providing solutions and recommendations for improving system performance and efficiency
Developing and implementing disaster recovery procedures for mainframe systems




Dustin Ryan
dustin@ryan.com
•
(806) 719-3491
•
linkedin.com/in/dustin-ryan
•
@dustin.ryan
•
github.com/dustinryan
Mainframe Developer
Seasoned Mainframe Developer with 15+ years of expertise in COBOL, JCL, and DB2 optimization. Proficient in modernizing legacy systems and implementing cloud integration strategies, resulting in a 40% improvement in processing efficiency for a Fortune 500 client. Adept at leading cross-functional teams and driving innovation in mainframe environments while ensuring robust cybersecurity measures.
WORK EXPERIENCE
Mainframe Developer
04/2022 – Present
Nebula Systems
Architected and implemented a hybrid cloud integration framework connecting legacy mainframe systems with AWS cloud services, reducing transaction processing time by 62% while maintaining 99.99% uptime
Spearheaded the modernization of 15+ critical COBOL applications using AI-assisted code refactoring tools, eliminating 78,000+ lines of redundant code and decreasing maintenance costs by $1.2M annually
Led a cross-functional team of 8 developers to design and deploy containerized mainframe workloads using zCX, enabling seamless DevOps practices and reducing deployment cycles from weeks to hours
Senior Mainframe Systems Analyst
03/2020 – 03/2022
SpireLake Medical
Engineered a real-time data synchronization solution between DB2 and distributed databases, processing over 3 million daily transactions with zero data loss during the 6-month implementation period
Optimized CICS transaction processing by redesigning JCL workflows and implementing parallel processing techniques, resulting in a 43% reduction in batch processing time
Developed and implemented automated testing frameworks for mainframe applications using Topaz for Total Test, increasing test coverage by 65% while reducing QA cycles by 3 weeks
Junior Mainframe Developer
01/2018 – 02/2020
NovaSpark Healthcare
Diagnosed and resolved 120+ production issues within SLA timeframes, achieving a first-call resolution rate of 87% and earning recognition as top support specialist for Q3
Collaborated with senior developers to refactor legacy COBOL programs, converting 35,000+ lines of monolithic code into modular, reusable components
Created comprehensive documentation for mainframe disaster recovery procedures, which proved instrumental during an unplanned outage, enabling system restoration 40% faster than previous incidents
SKILLS & COMPETENCIES
COBOL and JCL Programming Mastery
z/OS System Architecture and Administration
DB2 Database Management and Optimization
CICS Transaction Processing
Agile Mainframe Development Methodologies
Cloud-Mainframe Integration Strategies
Advanced Problem-Solving and Debugging
Cross-Functional Team Leadership
Legacy System Modernization
DevOps for Mainframe Environments
Effective Technical Communication
AI-Driven Mainframe Performance Tuning
Continuous Integration/Continuous Deployment (CI/CD) for Mainframe
Blockchain Integration with Mainframe Systems
COURSES / CERTIFICATIONS
IBM Certified System Programmer - z/OS
02/2025
IBM